/*
 * Decompiled with CFR 0.152.
 */
import bird.util.Dbg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class Status {
    private JPanel statusPanel_ = null;
    private JTextArea statusField_ = null;
    private JScrollPane statusScroll_;
    private String statusMsg_ = "";
    private Color bgColor_;
    private static Status inst_ = null;
    public static final int COND_NORMAL = 0;
    public static final int COND_WARNING = 1;
    public static final int COND_ERROR = 2;

    public static Status getInst() {
        if (inst_ == null) {
            inst_ = new Status();
        }
        return inst_;
    }

    public JPanel createGUI() {
        this.statusPanel_ = new JPanel(new BorderLayout(2, 2));
        this.statusField_ = new JTextArea(4, 15);
        this.statusScroll_ = new JScrollPane(this.statusField_, 20, 31);
        this.statusScroll_.setPreferredSize(new Dimension(250, 120));
        this.statusPanel_.add((Component)this.statusScroll_, "Center");
        this.statusPanel_.setBorder(BorderFactory.createTitledBorder("Status"));
        return this.statusPanel_;
    }

    public synchronized void log(String string, int n) {
        if (this.statusField_ == null) {
            return;
        }
        this.statusMsg_ = string;
        switch (n) {
            case 1: {
                this.bgColor_ = Color.YELLOW;
                break;
            }
            case 2: {
                this.bgColor_ = Color.RED;
                break;
            }
            default: {
                this.bgColor_ = Color.LIGHT_GRAY;
            }
        }
        this.updateGUI();
    }

    public void log(String string) {
        this.log(string, 0);
    }

    public synchronized void append(String string, int n) {
        this.log(string, n);
    }

    public void append(String string) {
        this.append(string, 0);
    }

    public synchronized void clear() {
        if (this.statusField_ == null) {
            return;
        }
        this.statusMsg_ = "";
        this.bgColor_ = Color.LIGHT_GRAY;
        this.updateGUI();
    }

    public void addKeyListener(KeyListener keyListener) {
        this.statusField_.addKeyListener(keyListener);
    }

    private Status() {
    }

    private void updateStatus() {
        JScrollBar jScrollBar = this.statusScroll_.getVerticalScrollBar();
        if (jScrollBar != null) {
            jScrollBar.setValue(jScrollBar.getMaximum());
        }
        this.statusField_.repaint();
    }

    private void updateGUI() {
        this.statusField_.append(this.statusMsg_);
        Runnable runnable = new Runnable(){

            public void run() {
                Status.this.updateStatus();
            }
        };
        try {
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception exception) {
            Dbg.getInst().log("+++++ status GUI update error! exc: " + exception + " +++++", Dbg.LVL_SYS);
        }
        Thread.yield();
    }
}

